<?php defined('SYSPATH') or die('No direct script access.');

class Task_Parser_Logmein_Insert extends Minion_Task{
    protected function _execute(array $params){
        Task_Helper::createWorker('Logmein', $this);
    }

    public function Worker(GearmanJob $job){
        $q = json_decode($job->workload(), true);
        $query = $this->getQuery($q['test_id']);

        $fp = fopen('/home/logmein2/'.$q['client'].'.csv', 'w');
        foreach($query as $item){
            $tmp_array = array();
            foreach($item as $key => $item2){
                if($key != 'data'){
                    $tmp_array[] = $item2;
                }else{
                    $data_string = '';
                    $data = json_decode($item2, true);
                    foreach($data as $k => $d){
                        $data_string .= $k.": ".$d."\n\r";
                    }
                    $tmp_array[] = $data_string;
                }
            }
            fputcsv($fp, $tmp_array);
        }

        fclose($fp);
    }

    private function getQuery($id){
        return DB::select('l.id', 't.client', 'l.referrer', 'l.link', 'l.datetime', 'l.data')
            ->from(['logpost', 'l'])
            ->join(['test', 't'])
            ->on('l.test_id', '=', 't.id')
            ->where(DB::expr('(EXTRACT(MONTH FROM l.datetime))'), '=', 3)
            ->and_where('l.test_id', '=', $id)
            ->execute()
            ->as_array();
    }
}